/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.base;

import com.atlassian.cmpt.check.base.CheckContext;
import com.atlassian.cmpt.check.base.CheckResult;
import java.util.Collections;
import java.util.Optional;

@FunctionalInterface
public interface Checker<T extends CheckContext> {
    public static final String EXECUTION_ERROR_CODE_KEY = "executionErrorDetails";

    public static CheckResult buildCheckResultWithExecutionError(int executionErrorCode) {
        return new CheckResult(false, Collections.singletonMap(EXECUTION_ERROR_CODE_KEY, executionErrorCode));
    }

    public static Integer retrieveExecutionErrorCode(CheckResult checkResult) {
        return Optional.ofNullable(checkResult).map(cr -> (Integer)cr.details.get(EXECUTION_ERROR_CODE_KEY)).orElse(null);
    }

    public CheckResult check(T var1);
}

