/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics.events;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventValidationResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EventValidationUtils {
    private EventValidationUtils() {
    }

    public static void checkAttributeIsSet(String key, EventDto eventDto, List<EventValidationResult.EventValidationItem> errors) {
        Object value = eventDto.getAttribute(key);
        if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
            errors.add(new EventValidationResult.EventValidationItem(key, "", String.format("Attribute [%s] is not set", key)));
        }
    }

    public static void checkAttributeHasValidValues(String key, EventDto eventDto, List<?> validValues, List<EventValidationResult.EventValidationItem> errors) {
        Object value = eventDto.getAttribute(key);
        if (value == null) {
            return;
        }
        if (!validValues.contains(value)) {
            String validValuesAsString = validValues.stream().map(Object::toString).collect(Collectors.joining(", "));
            errors.add(new EventValidationResult.EventValidationItem(key, value.toString(), String.format("Attribute [%s] has invalid value. Valid values are: [%s]", key, validValuesAsString)));
        }
    }
}

