/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics.events;

import com.atlassian.cmpt.analytics.ContextContainer;
import com.atlassian.cmpt.analytics.ContextObject;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class ActionDrivenEventDto
extends EventDto {
    @Nullable
    public final String source;
    @Nullable
    public final ContextContainer container;
    @Nullable
    public final ContextObject object;
    @Nullable
    public final String actionSubjectId;
    @Nullable
    public final String actionSubject;
    public final String action;

    ActionDrivenEventDto(Builder<?, ?> builder) {
        super(builder);
        this.source = ((Builder)builder).source;
        this.action = ((Builder)builder).action;
        this.actionSubject = ((Builder)builder).actionSubject;
        this.actionSubjectId = ((Builder)builder).actionSubjectId;
        this.container = ((Builder)builder).contextContainer;
        this.object = ((Builder)builder).contextObject;
    }

    ActionDrivenEventDto(long timestamp, EventType eventType, String userId, Map<String, Object> attributes, String cloudId, String source, ContextContainer container, ContextObject object, String actionSubjectId, String actionSubject, String action, @Deprecated String containerType, @Deprecated String containerId, @Deprecated String objectType, @Deprecated String objectId) {
        super(timestamp, eventType, userId, attributes, cloudId);
        this.source = source;
        this.actionSubjectId = actionSubjectId;
        this.actionSubject = actionSubject;
        this.action = action;
        this.container = container != null ? container : (StringUtils.isNotEmpty((CharSequence)containerType) || StringUtils.isNotEmpty((CharSequence)containerId) ? new ContextContainer(containerType, containerId) : null);
        this.object = object != null ? object : (StringUtils.isNotEmpty((CharSequence)objectType) || StringUtils.isNotEmpty((CharSequence)objectId) ? new ContextObject(objectType, objectId) : null);
    }

    public static abstract class Builder<T extends Builder<T, E>, E extends ActionDrivenEventDto>
    extends EventDto.Builder<T, E> {
        private String source;
        private String action;
        private String actionSubjectId;
        private String actionSubject;
        private ContextObject contextObject;
        private ContextContainer contextContainer;

        Builder(EventType eventType, long timestamp) {
            super(eventType, timestamp);
        }

        Builder(E event) {
            super(event);
            this.source = ((ActionDrivenEventDto)event).source;
            this.action = ((ActionDrivenEventDto)event).action;
            this.actionSubjectId = ((ActionDrivenEventDto)event).actionSubjectId;
            this.actionSubject = ((ActionDrivenEventDto)event).actionSubject;
            this.contextObject = ((ActionDrivenEventDto)event).object;
            this.contextContainer = ((ActionDrivenEventDto)event).container;
        }

        public T source(@Nullable String source) {
            this.source = source;
            return (T)((Builder)this.self());
        }

        public T action(String action) {
            this.action = Objects.requireNonNull(action);
            return (T)((Builder)this.self());
        }

        public T actionSubject(@Nullable String actionSubject, @Nullable String actionSubjectId) {
            this.actionSubject = actionSubject;
            this.actionSubjectId = actionSubjectId;
            return (T)((Builder)this.self());
        }

        public T actionSubject(@Nullable String actionSubject) {
            this.actionSubject = actionSubject;
            return (T)((Builder)this.self());
        }

        public T contextObject(@Nullable String type, @Nullable String id) {
            if (type != null) {
                this.contextObject = new ContextObject(type, id);
            }
            return (T)((Builder)this.self());
        }

        public T contextContainer(@Nullable String type, @Nullable String id) {
            if (type != null) {
                this.contextContainer = new ContextContainer(type, id);
            }
            return (T)((Builder)this.self());
        }
    }
}

