/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics;

import com.atlassian.cmpt.analytics.AnalyticsSubProduct;
import com.atlassian.cmpt.domain.ProductType;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public enum AnalyticsProduct {
    JIRA("jira", "jiraMigration", EnumSet.of(AnalyticsSubProduct.CORE, AnalyticsSubProduct.SOFTWARE, AnalyticsSubProduct.SERVICE_DESK)),
    CONFLUENCE("confluence", "confluenceMigration", EnumSet.noneOf(AnalyticsSubProduct.class));

    private final Set<AnalyticsSubProduct> subProducts;
    private final String nameV1;
    private final String nameV2;

    private AnalyticsProduct(String nameV1, String nameV2, Set<AnalyticsSubProduct> subProducts) {
        this.nameV1 = nameV1;
        this.nameV2 = nameV2;
        this.subProducts = subProducts;
    }

    public String getProductNameV1() {
        return this.nameV1;
    }

    public String getProductNameV2() {
        return this.nameV2;
    }

    public Set<AnalyticsSubProduct> getSubProducts() {
        return this.subProducts;
    }

    public static Optional<AnalyticsProduct> from(ProductType productType) {
        switch (productType) {
            case JIRA: {
                return Optional.of(JIRA);
            }
            case CONFLUENCE: {
                return Optional.of(CONFLUENCE);
            }
        }
        return Optional.empty();
    }
}

