package com.atlassian.cache.servlet.resolver;

import uk.ltd.getahead.dwr.AbstractDWRServlet;
import uk.ltd.getahead.dwr.DWRServlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class BogusDwrServlet extends HttpServlet
{
    private DWRServlet dwrServlet = new DWRServlet();

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException
    {
        try
        {
            Method method = findMethod();
            if (method == null)
            {
                throw new ServletException("Could not find doGet");
            }
            method.invoke(dwrServlet, new Object[] { req, resp });
        }
        catch (IllegalAccessException e)
        {
            throw new ServletException("Failed to fake DWR servlet", e);
        }
        catch (InvocationTargetException e)
        {
            throw new ServletException("Failed to fake DWR servlet", e);
        }
    }

    private Method findMethod()
    {
        Method method = null;

        Method[] methods = AbstractDWRServlet.class.getDeclaredMethods();
        //Method[] methods = DWRServlet.class.getDeclaredMethods(); DWR 1.0
        for (int i = 0; i < methods.length; i++)
        {
            Method aMethod = methods[i];
            if (aMethod.getName().equals("doGet"))
            {
                aMethod.setAccessible(true);
                method = aMethod;
                break;
            }
        }
        return method;
    }

    public void init(ServletConfig config) throws ServletException
    {
        dwrServlet.init(config);
    }
}
