package com.atlassian.cache.servlet.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Defines an interface that allows you to determine if a cache should be expired or not.
 */
public interface CacheExpirationHandler
{

    /**
     * Check whether we need to generate a response for this request. Set the necessary headers on the response, and if
     * we don't need to provide content, set the response status to 304.
     *
     * If this method returns true, the caller should not perform any more processing on the request.
     *
     * @return true if we don't need to provide any data to satisfy this request
     */
    public boolean checkRequest(HttpServletRequest request, HttpServletResponse response);

    /**
     * Call this if you want to alert the handler that the content has been modified.
     */
    public void modified();

}
