/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.impl.OneShotLatch;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;

public class BlockingCacheLoader<K, V>
extends CacheLoader<K, V> {
    private final ConcurrentMap<K, OneShotLatch> barriers = new ConcurrentHashMap<K, OneShotLatch>(16);
    private final CacheLoader<K, V> delegate;
    private final ReadWriteLock loadVsRemoveAllLock = new ReentrantReadWriteLock(true);

    BlockingCacheLoader(CacheLoader<K, V> delegate) {
        this.delegate = (CacheLoader)Assertions.notNull((String)"delegate", delegate);
    }

    Lock loadLock() {
        return this.loadVsRemoveAllLock.readLock();
    }

    Lock removeAllLock() {
        return this.loadVsRemoveAllLock.writeLock();
    }

    public V load(@Nonnull K key) throws Exception {
        this.acquire(key);
        this.loadLock().lock();
        return (V)this.delegate.load(key);
    }

    void postGetCleanup(@Nonnull K key) {
        OneShotLatch barrier = (OneShotLatch)this.barriers.get(key);
        if (barrier != null && barrier.isHeldByCurrentThread()) {
            this.loadLock().unlock();
            this.barriers.remove(key);
            barrier.release();
        }
    }

    OneShotLatch acquire(@Nonnull K key) {
        OneShotLatch barrier = new OneShotLatch();
        OneShotLatch existing;
        while ((existing = this.barriers.putIfAbsent(key, barrier)) != null) {
            existing.await();
        }
        return barrier;
    }

    void release(@Nonnull K key) {
        OneShotLatch existing = (OneShotLatch)this.barriers.get(key);
        if (existing == null || !existing.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("existing=" + existing);
        }
        this.barriers.remove(key);
        existing.release();
    }
}

