package com.atlassian.cache.memory;

import java.util.concurrent.TimeUnit;

import javax.annotation.Nonnull;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ManagedCache;

abstract class ManagedCacheSupport implements ManagedCache
{
    private final String name;
    private final CacheSettings settings;

    public ManagedCacheSupport(String name, CacheSettings settings)
    {
        this.name = name;
        this.settings = settings;
    }

    @Nonnull
    @Override
    public final String getName()
    {
        return name;
    }

    @Override
    public final boolean isFlushable()
    {
        return settings.getFlushable(true);
    }

    @Override
    public final boolean isLocal()
    {
        return true;
    }

    @Override
    public final boolean isReplicateAsynchronously()
    {
        return false;
    }

    @Override
    public final boolean isReplicateViaCopy()
    {
        return false;
    }

    @Override
    public final Integer currentMaxEntries()
    {
        return settings.getMaxEntries();
    }

    @Override
    public final boolean updateMaxEntries(int newValue)
    {
        return false;
    }

    @Override
    public final Long currentExpireAfterAccessMillis()
    {
        return settings.getExpireAfterAccess();
    }

    @Override
    public final boolean updateExpireAfterAccess(long expireAfter, @Nonnull TimeUnit timeUnit)
    {
        return false;
    }

    @Override
    public final Long currentExpireAfterWriteMillis()
    {
        return settings.getExpireAfterWrite();
    }

    @Override
    public final boolean updateExpireAfterWrite(long expireAfter, @Nonnull TimeUnit timeUnit)
    {
        return false;
    }

    @Override
    public boolean isStatisticsEnabled()
    {
        return settings.getStatisticsEnabled(false);
    }
}
