/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.AbstractCacheManager;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.cache.impl.StrongSupplier;
import com.atlassian.cache.impl.WeakSupplier;
import com.atlassian.cache.memory.DelegatingCache;
import com.atlassian.cache.memory.DelegatingCachedReference;
import com.atlassian.instrumentation.DefaultInstrumentRegistry;
import com.atlassian.instrumentation.SimpleTimer;
import com.atlassian.instrumentation.caches.CacheCollector;
import com.atlassian.instrumentation.caches.CacheKeys;
import com.atlassian.util.concurrent.ManagedLock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class MemoryCacheManager
extends AbstractCacheManager {
    @Nonnull
    public MemoryCacheManager() {
        super(null);
    }

    public MemoryCacheManager(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        super(cacheSettingsDefaultsProvider);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(final @Nonnull String name, final @Nonnull Supplier<V> supplier, @Nonnull CacheSettings settings) {
        final CacheSettings overridenSettings = this.mergeSettings(name, settings.override(new CacheSettingsBuilder().flushable().build()));
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock(new com.atlassian.util.concurrent.Supplier<DelegatingCachedReference<V>>(){

            public DelegatingCachedReference<V> get() {
                final DelegatingCachedReference.DelegatingReferenceRemovalListener listener = new DelegatingCachedReference.DelegatingReferenceRemovalListener();
                final CacheCollector collector = new DefaultInstrumentRegistry().pullCacheCollector(name);
                LoadingCache computingCache = MemoryCacheManager.createCacheBuilder(overridenSettings).removalListener(listener).build(new com.google.common.cache.CacheLoader<ReferenceKey, V>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public V load(@Nonnull ReferenceKey key) throws Exception {
                        if (collector.isEnabled()) {
                            SimpleTimer timer = new SimpleTimer(CacheKeys.LOAD_TIME.toString());
                            timer.start();
                            try {
                                Object value = supplier.get();
                                listener.onSupply(value);
                                Object object = value;
                                return object;
                            }
                            finally {
                                timer.end();
                                collector.miss();
                                collector.getSplits().add(timer);
                            }
                        }
                        Object value = supplier.get();
                        listener.onSupply(value);
                        return value;
                    }
                });
                DelegatingCachedReference cache = DelegatingCachedReference.create(computingCache, name, overridenSettings, collector);
                listener.setCachedReference(cache);
                MemoryCacheManager.this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
        });
    }

    protected ManagedCache createSimpleCache(final @Nonnull String name, final @Nonnull CacheSettings settings) {
        ManagedCache cache;
        com.atlassian.util.concurrent.Supplier cacheSupplier = (com.atlassian.util.concurrent.Supplier)this.caches.get(name);
        if (cacheSupplier != null && (cache = (ManagedCache)cacheSupplier.get()) != null) {
            return cache;
        }
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                if (!MemoryCacheManager.this.caches.containsKey(name)) {
                    DelegatingCache.DelegatingRemovalListener listener = new DelegatingCache.DelegatingRemovalListener();
                    Cache simpleCache = MemoryCacheManager.createCacheBuilder(settings).removalListener(listener).build();
                    DelegatingCache cache = DelegatingCache.create(simpleCache, name, settings, null);
                    listener.setCache(cache);
                    MemoryCacheManager.this.caches.put(name, new StrongSupplier(cache));
                }
                return (ManagedCache)((com.atlassian.util.concurrent.Supplier)MemoryCacheManager.this.caches.get(name)).get();
            }
        });
    }

    protected <K, V> ManagedCache createComputingCache(final @Nonnull String name, final @Nonnull CacheSettings settings, final CacheLoader<K, V> loader) {
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                final DelegatingCache.DelegatingRemovalListener listener = new DelegatingCache.DelegatingRemovalListener();
                CacheLoader wrappedLoader = new CacheLoader<K, V>(){

                    @Nonnull
                    public V load(@Nonnull K key) {
                        Object value = loader.load(key);
                        listener.onSupply(key, value);
                        return value;
                    }
                };
                Cache simpleCache = MemoryCacheManager.createCacheBuilder(settings).removalListener(listener).build();
                DelegatingCache cache = DelegatingCache.create(simpleCache, name, settings, wrappedLoader);
                listener.setCache(cache);
                MemoryCacheManager.this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
        });
    }

    private static CacheBuilder<Object, Object> createCacheBuilder(CacheSettings settings) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (null != settings.getMaxEntries()) {
            cacheBuilder.maximumSize((long)settings.getMaxEntries().intValue());
        }
        if (null != settings.getStatisticsEnabled() && settings.getStatisticsEnabled().booleanValue()) {
            cacheBuilder.recordStats();
        }
        if (null != settings.getExpireAfterAccess()) {
            cacheBuilder.expireAfterAccess(settings.getExpireAfterAccess().longValue(), TimeUnit.MILLISECONDS);
        } else if (null != settings.getExpireAfterWrite()) {
            cacheBuilder.expireAfterWrite(settings.getExpireAfterWrite().longValue(), TimeUnit.MILLISECONDS);
        }
        return cacheBuilder;
    }
}

