/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ManagedCache;
import com.atlassian.instrumentation.caches.CacheCollector;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class ManagedCacheSupport
implements ManagedCache {
    private final String name;
    private final CacheSettings settings;

    public ManagedCacheSupport(String name, CacheSettings settings) {
        this.name = name;
        this.settings = settings;
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    public final boolean isFlushable() {
        return this.settings.getFlushable(true);
    }

    public final boolean isLocal() {
        return true;
    }

    public final boolean isReplicateAsynchronously() {
        return false;
    }

    public final boolean isReplicateViaCopy() {
        return false;
    }

    public final Integer currentMaxEntries() {
        return this.settings.getMaxEntries();
    }

    public final boolean updateMaxEntries(int newValue) {
        return false;
    }

    public final Long currentExpireAfterAccessMillis() {
        return this.settings.getExpireAfterAccess();
    }

    public final boolean updateExpireAfterAccess(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return false;
    }

    public final Long currentExpireAfterWriteMillis() {
        return this.settings.getExpireAfterWrite();
    }

    public final boolean updateExpireAfterWrite(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return false;
    }

    public boolean isStatisticsEnabled() {
        return this.settings.getStatisticsEnabled(true);
    }

    public void setStatistics(boolean enabled) {
        throw new UnsupportedOperationException("setStatistics not implemented");
    }

    @Nullable
    public CacheCollector getCacheCollector() {
        return null;
    }
}

