/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheBuilder;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.memory.DelegatingCache;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCacheBuilder<K, V>
extends CacheBuilder<K, V> {
    protected final MemoryCacheManager factory;

    public MemoryCacheBuilder(String name, MemoryCacheManager factory) {
        super(name);
        this.factory = factory;
    }

    public Cache<K, V> build() {
        return this.factory.getCache(this);
    }

    Cache<K, V> createCache() {
        if (this.loader == null) {
            return this.createSimpleCache(this.name, this.flushable);
        }
        return this.createComputingCache(this.name, this.flushable);
    }

    Cache<K, V> createComputingCache(String name, boolean flushable) {
        if (this.loader == null) {
            throw new CacheException("You can't create a computing cache, without a Loader");
        }
        MapMaker mapMaker = new MapMaker();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        if (this.expireAfterMillis != -1L) {
            mapMaker.expireAfterAccess(this.expireAfterMillis, TimeUnit.MILLISECONDS);
        }
        ConcurrentMap computingCache = mapMaker.makeComputingMap(new Function<K, V>(){

            public V apply(@Nullable K key) {
                return MemoryCacheBuilder.this.loader.load(key);
            }
        });
        return new DelegatingCache(computingCache, name, flushable);
    }

    public <K, V> Cache<K, V> createSimpleCache(String name, boolean flushable) {
        return new DelegatingCache(new ConcurrentHashMap(), name, flushable);
    }
}

