/**
 *
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryCache<K, V> implements Cache<K, V>
{
    private final String cacheName;
    private final Map<K, V> cache = new ConcurrentHashMap<K, V>();

    public MemoryCache(final String cacheName)
    {
        if (cacheName == null)
        {
            throw new IllegalArgumentException("Cache name must not be null when constructing a MemoryCache!");
        }
        this.cacheName = cacheName;
    }

    public String getName()
    {
        return cacheName;
    }

    public Collection<K> getKeys()
    {
        return new ArrayList<K>(cache.keySet());
    }

    public V get(final K key)
    {
        return cache.get(key);
    }

    public void put(final K key, final V value)
    {
        cache.put(key, value);
    }

    public void remove(final K key)
    {
        cache.remove(key);
    }

    public void removeAll()
    {
        cache.clear();
    }

    public boolean equals(Object obj)
    {
        if (obj == null)
        {
            return false;
        }
        if (getClass() != obj.getClass())
        {
            return false;
        }
        final MemoryCache other = (MemoryCache) obj;
        return other.cacheName.equals(this.cacheName);
    }

    public int hashCode()
    {
        return 3 + this.cacheName.hashCode();
    }
}