package com.atlassian.cache.empty;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;

import java.util.Collection;
import java.util.Collections;

public class EmptyCacheManager implements CacheManager
{
    public Collection<Cache<?, ?>> getCaches()
    {
        return Collections.emptyList();
    }

    public void flushCaches()
    {
        // ignore
    }

    public <K, V> Cache<K, V> getCache(final String name)
    {
        return getCache(name, null, null);
    }

    public <K, V> Cache<K, V> getCache(final String name, final Class<K> keyType, final Class<V> valueType)
    {
        return new EmptyCache<K, V>(name);
    }

    private static class EmptyCache<K, V> implements Cache<K, V>
    {
        private final String name;

        public EmptyCache(final String name)
        {
            this.name = name;
        }

        public String getName()
        {
            return name;
        }

        public Collection<K> getKeys()
        {
            return Collections.emptyList();
        }

        public V get(final K key)
        {
            return null; // empty cache
        }

        public void put(final K key, final V value)
        {
            // ignore
        }

        public void remove(final K key)
        {
            // ignore
        }

        public void removeAll()
        {
            // ignore
        }
    }
}
