package com.atlassian.cache.hazelcast;

import com.google.common.base.Objects;

class Versioned<T>
{
    @SuppressWarnings ({"unchecked", "rawtypes"})
    private static final Versioned EMPTY = new Versioned(null, 0L);

    private final long version;
    private final T value;

    Versioned(T value, long version)
    {
        this.value = value;
        this.version = version;
    }

    @SuppressWarnings ("unchecked")
    public static <T> Versioned<T> empty()
    {
        return EMPTY;
    }

    public T getValue()
    {
        return value;
    }

    public long getVersion()
    {
        return version;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        Versioned<?> other = (Versioned<?>) o;
        return version == other.version && Objects.equal(value, other.value);
    }

    @Override
    public int hashCode()
    {
        int result = (int) (version ^ (version >>> 32));
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString()
    {
        return "Versioned[version=" + version + "; value=" + value + ']';
    }
}
