package com.atlassian.cache.hazelcast;

import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;

import javax.annotation.Nonnull;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * Common implementation of {@link com.atlassian.cache.ManagedCache} methods for hybrid caches and cached references.
 *
 * @since 2.4.0
 */
public abstract class ManagedHybridCacheSupport implements ManagedCache
{
    protected final HazelcastCacheManager cacheManager;
    protected final String name;

    public ManagedHybridCacheSupport(String name, HazelcastCacheManager cacheManager)
    {
        this.cacheManager = cacheManager;
        this.name = name;
    }

    @Override
    public Long currentExpireAfterAccessMillis()
    {
        return getLocalCache().currentExpireAfterAccessMillis();
    }

    @Override
    public Long currentExpireAfterWriteMillis()
    {
        return getLocalCache().currentExpireAfterWriteMillis();
    }

    @Override
    public Integer currentMaxEntries()
    {
        return getLocalCache().currentMaxEntries();
    }


    @Nonnull
    @Override
    public String getName()
    {
        return name;
    }

    @Override
    public boolean isLocal()
    {
        return false;
    }

    @Override
    public boolean isReplicateViaCopy()
    {
        return false;
    }

    @Override
    public boolean updateExpireAfterAccess(long expireAfter, @Nonnull TimeUnit timeUnit)
    {
        return getLocalCache().updateExpireAfterAccess(expireAfter, timeUnit);
    }

    @Override
    public boolean updateExpireAfterWrite(long expireAfter, @Nonnull TimeUnit timeUnit)
    {
        return getLocalCache().updateExpireAfterAccess(expireAfter, timeUnit);
    }

    @Override
    public boolean updateMaxEntries(int newValue)
    {
        return getLocalCache().updateMaxEntries(newValue);
    }

    protected abstract ManagedCache getLocalCache();

    /**
     * For hybrid caches, we can just get the cache stats from the underlying local cache.
     */
    @Nonnull
    @Override
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics()
    {
        return getLocalCache().getStatistics();
    }

    @Override
    public boolean isStatisticsEnabled()
    {
        return getLocalCache().isStatisticsEnabled();
    }

    @Override
    public void setStatistics(boolean enabled) { getLocalCache().setStatistics(enabled); }
}