package com.atlassian.cache.hazelcast;

import java.util.Map;

import com.hazelcast.map.AbstractEntryProcessor;

class IncrementVersionEntryProcessor<K> extends AbstractEntryProcessor<K, Long>
{
    private static final IncrementVersionEntryProcessor<Object> INSTANCE =
            new IncrementVersionEntryProcessor<Object>();

    protected static <T> IncrementVersionEntryProcessor<T> getInstance()
    {
        //noinspection unchecked
        return (IncrementVersionEntryProcessor<T>) INSTANCE;
    }

    private IncrementVersionEntryProcessor()
    {
    }

    @Override
    public Object process(Map.Entry<K, Long> entry)
    {
        Long value = entry.getValue();
        value = value == null ? 1L : value + 1L;
        entry.setValue(value);
        return value;
    }
}
