package com.atlassian.cache.hazelcast;

import javax.annotation.Nonnull;

import com.atlassian.cache.CacheLoader;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Cache loader wrapper which will re-invoke original loader if cache version changes while entry loading was in
 * progress
 * <p>
 * Cache version changed each time when removeAll or clear is called
 */
public class CacheVersionAwareCacheLoader<K, V> implements CacheLoader<K, V>
{
    private final CacheLoader<K, V> delegate;
    private final CacheVersion cacheVersion;

    CacheVersionAwareCacheLoader(CacheLoader<K, V> delegate, CacheVersion cacheVersion)
    {
        this.delegate = checkNotNull(delegate);
        this.cacheVersion = checkNotNull(cacheVersion);
    }

    @Nonnull
    @Override
    public V load(@Nonnull K key)
    {
        V v;
        long currentVersion;

        do
        {
            currentVersion = cacheVersion.get();
            v = delegate.load(key);
        }
        while (currentVersion != cacheVersion.get());

        return v;
    }
}