/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.hazelcast;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.ImmutableSortedMap;
import com.hazelcast.config.MapConfig;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ManagedCacheSupport
implements ManagedCache {
    private final MapConfig config;
    private final boolean flushable;
    private final String name;

    public ManagedCacheSupport(String name, MapConfig config, CacheSettings settings) {
        this.config = config;
        this.flushable = settings.getFlushable(true);
        this.name = name;
    }

    @Nullable
    public Long currentExpireAfterAccessMillis() {
        long maxIdle = TimeUnit.SECONDS.toMillis(this.config.getMaxIdleSeconds());
        return maxIdle > 0L ? Long.valueOf(maxIdle) : null;
    }

    @Nullable
    public Long currentExpireAfterWriteMillis() {
        long timeToLive = TimeUnit.SECONDS.toMillis(this.config.getTimeToLiveSeconds());
        return timeToLive > 0L ? Long.valueOf(timeToLive) : null;
    }

    @Nullable
    public Integer currentMaxEntries() {
        int maxSize = this.config.getMaxSizeConfig().getSize();
        return maxSize > 0 ? Integer.valueOf(maxSize) : null;
    }

    public boolean isReplicateViaCopy() {
        return true;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isFlushable() {
        return this.flushable;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isReplicateAsynchronously() {
        return false;
    }

    public boolean updateExpireAfterAccess(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return false;
    }

    public boolean updateExpireAfterWrite(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return false;
    }

    public boolean updateMaxEntries(int newValue) {
        return false;
    }

    @Nonnull
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        return ImmutableSortedMap.of();
    }
}

