/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.hazelcast;

import com.atlassian.cache.CacheSettings;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.NearCacheConfig;
import java.util.Random;

public class HazelcastMapConfigConfigurator {
    public static final int HYBRID_MULTIPLIER = 2;
    public static final int NEAR_CACHE_EXPIRY_RATIO = Integer.getInteger("atlassian.cache.nearCacheExpiryRatio", 75);

    public MapConfig configureMapConfig(CacheSettings settings, MapConfig mapConfig) {
        boolean nearCache;
        Long expireAfterWrite;
        Long expireAfterAccess;
        NearCacheConfig nearCacheConfig;
        boolean hybrid = !settings.getReplicateViaCopy(true);
        Integer multiplier = hybrid ? 2 : 1;
        Integer maxEntries = settings.getMaxEntries();
        NearCacheConfig nearCacheConfig2 = nearCacheConfig = mapConfig.getNearCacheConfig() == null ? new NearCacheConfig() : new NearCacheConfig(mapConfig.getNearCacheConfig());
        if (maxEntries != null) {
            int maxSize = multiplier * maxEntries;
            mapConfig.setMaxSizeConfig(new MaxSizeConfig().setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.PER_NODE).setSize(maxSize));
            mapConfig.setEvictionPolicy(EvictionPolicy.LFU);
            nearCacheConfig.setMaxSize(maxSize);
            nearCacheConfig.setEvictionPolicy(EvictionPolicy.LFU.name());
        }
        if ((expireAfterAccess = settings.getExpireAfterAccess()) != null) {
            int maxIdleSeconds = multiplier * HazelcastMapConfigConfigurator.roundUpToWholeSeconds(expireAfterAccess);
            mapConfig.setMaxIdleSeconds(maxIdleSeconds);
            int jitter = new Random().nextInt(30) - 15;
            int nearCacheTtl = (int)Math.round((double)((NEAR_CACHE_EXPIRY_RATIO + jitter) * maxIdleSeconds) / 100.0);
            nearCacheConfig.setTimeToLiveSeconds(Math.max(1, nearCacheTtl));
        }
        if ((expireAfterWrite = settings.getExpireAfterWrite()) != null) {
            int timeToLiveSeconds = multiplier * HazelcastMapConfigConfigurator.roundUpToWholeSeconds(expireAfterWrite);
            mapConfig.setTimeToLiveSeconds(timeToLiveSeconds);
            nearCacheConfig.setTimeToLiveSeconds(timeToLiveSeconds);
        }
        if (nearCache = settings.getReplicateAsynchronously(true)) {
            mapConfig.setNearCacheConfig(nearCacheConfig);
        } else {
            mapConfig.setNearCacheConfig(null);
        }
        return mapConfig;
    }

    private static int roundUpToWholeSeconds(Long expireAfterAccess) {
        return (int)Math.ceil((double)expireAfterAccess.longValue() / 1000.0);
    }
}

