/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava11.memory;

import com.atlassian.cache.compat.CacheException;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.impl.ReferenceKey;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import javax.annotation.Nullable;

class MemoryCachedReference<V>
implements CachedReference<V> {
    private final LoadingCache<ReferenceKey, V> internalCache;

    private MemoryCachedReference(LoadingCache<ReferenceKey, V> internalCache) {
        this.internalCache = internalCache;
    }

    static <V> MemoryCachedReference<V> create(LoadingCache<ReferenceKey, V> internalCache) {
        return new MemoryCachedReference<V>(internalCache);
    }

    public V get() {
        try {
            return (V)this.internalCache.get((Object)ReferenceKey.KEY);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void reset() {
        try {
            this.internalCache.invalidateAll();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof MemoryCachedReference) {
            MemoryCachedReference otherDelegatingReference = (MemoryCachedReference)other;
            if (this.internalCache.equals(otherDelegatingReference.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

