package com.atlassian.cache.compat.guava11.memory;

import com.atlassian.cache.compat.CacheException;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.impl.ReferenceKey;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;

import javax.annotation.Nullable;

/**
 * A Lazy Reference that delegates LoadingCache.
 *
 * @since v1.0
 */
class MemoryCachedReference<V> implements CachedReference<V>
{
    private final LoadingCache<ReferenceKey, V> internalCache;

    private MemoryCachedReference(final LoadingCache<ReferenceKey, V> internalCache)
    {
        this.internalCache = internalCache;
    }

    static <V> MemoryCachedReference<V> create(final LoadingCache<ReferenceKey, V> internalCache)
    {
        return new MemoryCachedReference<V>(internalCache);
    }



    @Override
    public V get()
    {
        try
        {
            return internalCache.get(ReferenceKey.KEY);
        }
        catch (ComputationException e)
        {
            throw new CacheException(e.getCause());
        }
        catch (Exception e)
        {
            throw new CacheException(e);
        }
    }

    @Override
    public void reset()
    {
        try
        {
            internalCache.invalidateAll();
        }
        catch (Exception e)
        {
            throw new CacheException(e);
        }
    }



    @Override
    public boolean equals(@Nullable final Object other)
    {
        if (other instanceof MemoryCachedReference)
        {
            MemoryCachedReference otherDelegatingReference = (MemoryCachedReference) other;
            if (internalCache.equals(otherDelegatingReference.internalCache))
            {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode()
    {
        return 3 + internalCache.hashCode();
    }
}
