/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheStatisticsKey;
import io.atlassian.util.concurrent.Suppliers;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.sf.ehcache.statistics.StatisticsGateway;

public class DelegatingCacheStatistics {
    public static SortedMap<CacheStatisticsKey, Supplier<Long>> toStatistics(StatisticsGateway stats) {
        TreeMap<CacheStatisticsKey, Supplier> map = new TreeMap<CacheStatisticsKey, Supplier>(CacheStatisticsKey.SORT_BY_LABEL);
        map.put(CacheStatisticsKey.SIZE, Suppliers.memoize((Object)stats.getSize()));
        map.put(CacheStatisticsKey.HEAP_SIZE, () -> ((StatisticsGateway)stats).getLocalHeapSizeInBytes());
        map.put(CacheStatisticsKey.HIT_COUNT, Suppliers.memoize((Object)stats.cacheHitCount()));
        map.put(CacheStatisticsKey.PUT_COUNT, Suppliers.memoize((Object)stats.cachePutCount()));
        map.put(CacheStatisticsKey.REMOVE_COUNT, Suppliers.memoize((Object)stats.cacheRemoveCount()));
        map.put(CacheStatisticsKey.MISS_COUNT, Suppliers.memoize((Object)stats.cacheMissCount()));
        map.put(CacheStatisticsKey.EVICTION_COUNT, Suppliers.memoize((Object)stats.cacheEvictedCount()));
        return Collections.unmodifiableSortedMap(map);
    }
}

