package com.atlassian.cache.ehcache;

import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;

import com.atlassian.cache.CacheStatisticsKey;

import net.sf.ehcache.statistics.StatisticsGateway;

import static com.atlassian.cache.CacheStatisticsKey.EVICTION_COUNT;
import static com.atlassian.cache.CacheStatisticsKey.HEAP_SIZE;
import static com.atlassian.cache.CacheStatisticsKey.HIT_COUNT;
import static com.atlassian.cache.CacheStatisticsKey.MISS_COUNT;
import static com.atlassian.cache.CacheStatisticsKey.PUT_COUNT;
import static com.atlassian.cache.CacheStatisticsKey.REMOVE_COUNT;
import static com.atlassian.cache.CacheStatisticsKey.SIZE;
import static io.atlassian.util.concurrent.Suppliers.memoize;

/**
 * @since v2.4.0
 */
public class DelegatingCacheStatistics
{
    public static SortedMap<CacheStatisticsKey, Supplier<Long>> toStatistics(final StatisticsGateway stats)
    {
        final SortedMap<CacheStatisticsKey, Supplier<Long>> map = new TreeMap<>(CacheStatisticsKey.SORT_BY_LABEL);
        map.put(SIZE, memoize(stats.getSize()));
        // Note: While most of these statistics we can reasonably expect to be cheap and just memoize, the
        // heap size in bytes is very likely to be expensive.  To make it possible to opt out of retrieving
        // it, we hide it behind a Supplier, here.
        map.put(HEAP_SIZE, stats::getLocalHeapSizeInBytes);
        map.put(HIT_COUNT, memoize(stats.cacheHitCount()));
        map.put(PUT_COUNT, memoize(stats.cachePutCount()));
        map.put(REMOVE_COUNT, memoize(stats.cacheRemoveCount()));
        map.put(MISS_COUNT, memoize(stats.cacheMissCount()));
        map.put(EVICTION_COUNT, memoize(stats.cacheEvictedCount()));

        return Collections.unmodifiableSortedMap(map);
    }
}
