/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.ehcache.DelegatingCache;
import com.atlassian.cache.ehcache.DelegatingCachedReference;
import com.atlassian.cache.ehcache.EhCacheHelper;
import com.atlassian.cache.impl.AbstractCacheManager;
import com.atlassian.cache.impl.StrongSupplier;
import com.atlassian.cache.impl.WeakSupplier;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.util.concurrent.ManagedLock;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.management.ManagementService;

public class EhCacheManager
extends AbstractCacheManager
implements MBeanRegistrar {
    private CacheManager delegate;

    public EhCacheManager() {
        this(CacheManager.create());
    }

    public EhCacheManager(CacheManager delegate) {
        this.delegate = delegate;
    }

    CacheManager getEh() {
        return this.delegate;
    }

    public <V> CachedReference<V> getCachedReference(final String name, final Supplier<V> supplier, CacheSettings settings) {
        final CacheSettings overridenSettings = settings.override(new CacheSettingsBuilder().flushable().maxEntries(1).build());
        if (this.caches.containsKey(name)) {
            if (settings.getReplicateViaCopy(false)) {
                Cache ehCache = this.delegate.getCache(name);
                DelegatingCachedReference cache = DelegatingCachedReference.create((Ehcache)ehCache, settings);
                this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
            this.delegate.removeCache(name);
        }
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock(new com.atlassian.util.concurrent.Supplier<DelegatingCachedReference<V>>(){

            public DelegatingCachedReference<V> get() {
                Ehcache ehcache = EhCacheManager.this.createCache(name, overridenSettings, true);
                SelfPopulatingCache spCache = new SelfPopulatingCache(ehcache, new CacheEntryFactory(){

                    public Object createEntry(Object o) throws Exception {
                        return supplier.get();
                    }
                });
                DelegatingCachedReference cache = DelegatingCachedReference.create((Ehcache)spCache, overridenSettings);
                EhCacheManager.this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
        });
    }

    protected ManagedCache createSimpleCache(final String name, final CacheSettings settings) {
        ManagedCache cache;
        com.atlassian.util.concurrent.Supplier cacheSupplier = (com.atlassian.util.concurrent.Supplier)this.caches.get(name);
        if (cacheSupplier != null && (cache = (ManagedCache)cacheSupplier.get()) != null) {
            return cache;
        }
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                if (!EhCacheManager.this.caches.containsKey(name)) {
                    Ehcache simpleCache = EhCacheManager.this.createCache(name, settings, false);
                    DelegatingCache cache = DelegatingCache.create(simpleCache, settings);
                    EhCacheManager.this.caches.put(name, new StrongSupplier(cache));
                }
                return (ManagedCache)((com.atlassian.util.concurrent.Supplier)EhCacheManager.this.caches.get(name)).get();
            }
        });
    }

    protected <K, V> ManagedCache createComputingCache(final String name, final CacheSettings settings, final CacheLoader<K, V> loader) {
        if (this.caches.containsKey(name)) {
            if (settings.getReplicateViaCopy(false)) {
                Cache delegateCache = this.delegate.getCache(name);
                DelegatingCache cache = DelegatingCache.create((Ehcache)delegateCache, settings);
                this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
            this.delegate.removeCache(name);
        }
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                Ehcache ehcache = EhCacheManager.this.createCache(name, settings, true);
                SelfPopulatingCache spCache = new SelfPopulatingCache(ehcache, new CacheEntryFactory(){

                    public Object createEntry(Object key) throws Exception {
                        if (key == null) {
                            throw new NullPointerException();
                        }
                        Object loaderKey = key;
                        return loader.load(loaderKey);
                    }
                });
                DelegatingCache cache = DelegatingCache.create((Ehcache)spCache, settings);
                EhCacheManager.this.caches.put(name, new WeakSupplier(cache));
                return cache;
            }
        });
    }

    private Ehcache createCache(String name, CacheSettings settings, boolean selfLoading) {
        return new EhCacheHelper().getEhcache(name, this.delegate, settings, selfLoading);
    }

    public void registerMBeans(@Nullable MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            ManagementService.registerMBeans((CacheManager)this.delegate, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }
}

