/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ehcache.ManagedCacheSupport;
import com.atlassian.cache.impl.ReferenceKey;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

class DelegatingCachedReference<V>
extends ManagedCacheSupport
implements CachedReference<V> {
    private final Ehcache delegate;

    private DelegatingCachedReference(Ehcache delegate, CacheSettings settings) {
        super(delegate, settings);
        this.delegate = delegate;
    }

    static <V> DelegatingCachedReference<V> create(Ehcache delegate, CacheSettings settings) {
        return new DelegatingCachedReference<V>(delegate, settings);
    }

    public V get() {
        try {
            Element element = this.delegate.get((Serializable)ReferenceKey.KEY);
            return (V)(element == null ? null : element.getObjectValue());
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void reset() {
        try {
            this.delegate.remove((Serializable)ReferenceKey.KEY);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.reset();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCachedReference) {
            DelegatingCachedReference otherDelegatingReference = (DelegatingCachedReference)other;
            if (this.delegate.equals(otherDelegatingReference.delegate)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.delegate.hashCode();
    }
}

