/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.ehcache.DelegatingCacheStatistics;
import com.atlassian.cache.ehcache.ManagedCacheSupport;
import com.atlassian.cache.impl.CachedReferenceListenerSupport;
import com.atlassian.cache.impl.LazyCachedReferenceListenerSupport;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.instrumentation.caches.CacheCollector;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.ImmutableSortedMap;
import java.io.Serializable;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

class DelegatingCachedReference<V>
extends ManagedCacheSupport
implements CachedReference<V> {
    private final Ehcache delegate;
    private final CachedReferenceListenerSupport<V> listenerSupport = new LazyCachedReferenceListenerSupport<V>(){

        protected void init() {
            DelegatingCachedReference.this.delegate.getCacheEventNotificationService().registerListener((CacheEventListener)new DelegatingReferenceCacheEventListener());
        }
    };

    private DelegatingCachedReference(Ehcache delegate, CacheSettings settings) {
        super(delegate, settings);
        this.delegate = delegate;
    }

    static <V> DelegatingCachedReference<V> create(Ehcache delegate, CacheSettings settings) {
        return new DelegatingCachedReference<V>(delegate, settings);
    }

    @Nonnull
    public V get() {
        try {
            return (V)this.delegate.get((Serializable)ReferenceKey.KEY).getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void reset() {
        try {
            this.delegate.remove((Serializable)ReferenceKey.KEY);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.reset();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCachedReference) {
            DelegatingCachedReference otherDelegatingReference = (DelegatingCachedReference)other;
            if (this.delegate.equals(otherDelegatingReference.delegate)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.delegate.hashCode();
    }

    @Nonnull
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        if (this.isStatisticsEnabled()) {
            return DelegatingCacheStatistics.toStatistics(this.delegate.getStatistics());
        }
        return ImmutableSortedMap.of();
    }

    @Nullable
    public CacheCollector getCacheCollector() {
        return null;
    }

    public void addListener(@Nonnull CachedReferenceListener<V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(@Nonnull CachedReferenceListener<V> listener) {
        this.listenerSupport.remove(listener);
    }

    private class DelegatingReferenceCacheEventListener
    implements CacheEventListener {
        private DelegatingReferenceCacheEventListener() {
        }

        public void notifyElementRemoved(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
            DelegatingCachedReference.this.listenerSupport.notifyReset(element.getObjectValue());
        }

        public void notifyElementPut(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
            DelegatingCachedReference.this.listenerSupport.notifySet(element.getObjectValue());
        }

        public void notifyElementUpdated(Ehcache ehcache, Element element) throws net.sf.ehcache.CacheException {
            DelegatingCachedReference.this.listenerSupport.notifySet(element.getObjectValue());
        }

        public void notifyElementExpired(Ehcache ehcache, Element element) {
            DelegatingCachedReference.this.listenerSupport.notifyEvict(element.getObjectValue());
        }

        public void notifyElementEvicted(Ehcache ehcache, Element element) {
            DelegatingCachedReference.this.listenerSupport.notifyEvict(element.getObjectValue());
        }

        public void notifyRemoveAll(Ehcache ehcache) {
            DelegatingCachedReference.this.listenerSupport.notifyReset(null);
        }

        public void dispose() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }
}

