package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.compat.CachedReference;

import static java.util.Objects.requireNonNull;

/**
 * @since v1.0
 */
public class DelegatingCachedReference<V> implements CachedReference<V>
{
    private final com.atlassian.cache.CachedReference<V> delegate;

    private DelegatingCachedReference(com.atlassian.cache.CachedReference<V> delegate)
    {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    @Override
    public V get()
    {
        return delegate.get();
    }

    @Override
    public void reset()
    {
        delegate.reset();
    }

    static <V> DelegatingCachedReference<V> wrapCachedReference(com.atlassian.cache.CachedReference<V> delegate)
    {
        return new DelegatingCachedReference<V>(delegate);
    }
}
