package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.compat.CacheLoader;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since v1.0
 */
public class DelegatingCacheLoader<K,V> implements com.atlassian.cache.CacheLoader<K,V>
{
    private final CacheLoader<K,V> delegate;

    private DelegatingCacheLoader(CacheLoader<K, V> delegate)
    {
        this.delegate = requireNonNull(delegate,"delegate");
    }

    @Override
    public V load(@Nonnull K key)
    {
        return delegate.load(key);
    }

    static <K,V> DelegatingCacheLoader<K,V> wrapCacheLoader(CacheLoader<K,V> delegate)
    {
        return (delegate != null) ? new DelegatingCacheLoader<K,V>(delegate) : null;
    }
}
