package com.atlassian.cache.compat.delegate;

import java.util.Collection;

import com.atlassian.cache.compat.Cache;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since v1.0
 */
public class DelegatingCache<K,V> implements Cache<K,V>
{
    private final com.atlassian.cache.Cache<K,V> delegate;

    private DelegatingCache(com.atlassian.cache.Cache<K, V> delegate)
    {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    @Override
    public String getName()
    {
        return delegate.getName();
    }

    @Override
    public Collection<K> getKeys()
    {
        return delegate.getKeys();
    }

    @Override
    public V get(@Nonnull K k)
    {
        return delegate.get(k);
    }

    @Override
    public void put(@Nonnull K k, V v)
    {
        delegate.put(k, v);
    }

    @Override
    public void remove(@Nonnull K k)
    {
        delegate.remove(k);
    }

    @Override
    public void removeAll()
    {
        delegate.removeAll();
    }

    static <K,V> DelegatingCache<K,V> wrapCache(com.atlassian.cache.Cache<K,V> delegate)
    {
        return new DelegatingCache<K,V>(delegate);
    }
}
