package com.atlassian.cache.compat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The cache-compat-library is consumed by UPM.  UPM needs to run in products that may export Guava 10, 11  or 18
 * This class tests the version of Guava by looking for the presence of LoadingCache.
 *
 * @since 1.1
 */
public class GuavaCacheVersionChecker
{
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityCacheFactory.class);
    private static final String LOADING_CACHE_CLASS = "com.google.common.cache.LoadingCache";
    private static boolean IS_GUAVA_11;

    static
    {
        try
        {
            GuavaCacheVersionChecker.class.getClassLoader().loadClass(LOADING_CACHE_CLASS);
            IS_GUAVA_11 = true;
        }
        catch (ClassNotFoundException e)
        {
            LOG.debug("LoadingCache not found, assuming Guava 10", e);
            IS_GUAVA_11 = false;
        }
    }

    static public boolean isGuavaVersion11()
    {
        return IS_GUAVA_11;
    }
}
