package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.compat.Supplier;

import static com.atlassian.util.concurrent.Assertions.notNull;

/**
 * @since v1.0
 */
public class DelegatingSupplier<T> implements com.atlassian.cache.Supplier<T>
{
    private final Supplier<T> delegate;

    private DelegatingSupplier(Supplier<T> delegate)
    {
        this.delegate = notNull("delegate", delegate);
    }

    @Override
    public T get()
    {
        return delegate.get();
    }

    static <T> DelegatingSupplier<T> wrapSupplier(Supplier<T> delegate)
    {
        return (delegate != null) ? new DelegatingSupplier<T>(delegate) : null;
    }
}

