package com.atlassian.cache.compat.impl;

import java.lang.ref.WeakReference;

import com.atlassian.cache.compat.Supplier;

/**
 * A supplier that holds a weak reference to its referent.
 * Contrast with {@link StrongSupplier}
 *
 * @since v1.0
 */
public class WeakSupplier<V> extends WeakReference<V> implements Supplier<V>
{
    public WeakSupplier(final V referent)
    {
        super(referent);
    }
}
