package com.atlassian.cache.compat;

import com.atlassian.annotations.PublicSpi;

/**
 * Supplier for a single object
 *
 * @since v1.0
 */
@PublicSpi
public interface Supplier<T>
{
    /**
     * Produce an object. Retrieve an instance of the appropriate type. The
     * returned object may or may not be a new instance, depending on the
     * implementation.
     *
     * @return the product, may be null if there are no objects available.
     */
    T get();
}
