package com.atlassian.cache.compat;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.util.concurrent.NotNull;

/**
 * Populates a cache, for example lazily upon a miss.
 *
 * @param <K> the type of key used by the cache
 * @param <V> the type of value stored in the cache
 * @since v1.0
 */
@PublicSpi
public interface CacheLoader<K, V>
{
    /**
     * Loads the value for the given key.
     *
     * @param key the key for which to load the value (required)
     * @return a non-null value; if null values are possible, e.g. when the key
     * is a database ID that does not actually exist, declare the loader's (and so the Cache's)
     * value type to be a wrapper type such as Guava's {@code Option<Foo>}
     * class
     */
    @NotNull V load(@NotNull K key);
}
