package com.atlassian.cache.impl;

import com.atlassian.cache.CacheEntryEvent;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A default implementation for {@code CacheEntryEvent}
 */
public class DefaultCacheEntryEvent<K, V> implements CacheEntryEvent<K, V>
{
    private final K key;
    private final V value;
    private final V oldValue;

    public DefaultCacheEntryEvent(@Nonnull K key, V value, V oldValue)
    {
        this.key = requireNonNull(key);
        this.value = value;
        this.oldValue = oldValue;
    }

    public DefaultCacheEntryEvent(@Nonnull K key)
    {
        this(key, null, null);
    }

    @Override
    @Nonnull
    public K getKey()
    {
        return key;
    }

    @Override
    public V getValue()
    {
        return value;
    }

    @Override
    public V getOldValue()
    {
        return oldValue;
    }
}
