package com.atlassian.cache.impl.metrics;

import static com.atlassian.cache.impl.metrics.MetricEmitter.CLASS_NAME_KEY;
import static com.atlassian.util.profiling.Metrics.metric;

/**
 * This class emits JMX metrics for the CacheManager
 * @since 5.5.0
 */
public class CacheManagerMetricEmitter
{
    private static final String CACHE_FLUSH_METRIC_NAME = "cacheManager.flushAll";

    public CacheManagerMetricEmitter()
    {
    }

    public void emitCacheManagerFlushAll(String className)
    {
        try
        {
            metric(CACHE_FLUSH_METRIC_NAME)
                    .withInvokerPluginKey()
                    .tag(CLASS_NAME_KEY, className)
                    .withAnalytics()
                    .incrementCounter(1L);
        } catch (NoClassDefFoundError ignored)
        {
            // CacheManager#flushAll can be called before the plugin system and the atlassian-profiling plugin
            // is initialised which will cause a NoClassDefFoundError. We do not mind ignoring this because calls before
            // this point are not valuable enough to attempt to emit a metric for
        }
    }
}
