package com.atlassian.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.atlassian.annotations.PublicApi;

/**
 * A cache event.
 * <p>
 * NOTE: Although Cache does not support {@code null} as a valid value we are using it in {@code getValue} and
 * {@code getOldValue} as a way to represent missing value. We have the following reasons for this:
 * <ul>
 *     <li>Firstly, some events inherently do not have value or old value. For instance addition does not have
 *     an old value as the corresponding element was just added to the cache</li>
 *     <li>Secondly, in some implementations the information for the value and/or old value is not available at all.</li>
 *     <li>Thirdly, the listener can be added as a valueless listener</li>
 * </ul>
 *
 * @since 2.4
 */
@PublicApi
public interface CacheEntryEvent<K, V>
{
    /**
     * Returns the key the event was fired for
     *
     * @return the key
     */
    @Nonnull
    K getKey();

    /**
     * Returns the current value for this key
     *
     * @return the value. For details why is this method marked as {@code Nullable} please refer to the
     * class level documentation
     */
    @Nullable
    V getValue();

    /**
     * Returns the old value for this key
     *
     * @return the old value. For details why is this method marked as {@code Nullable} please refer to the
     * class level documentation
     */
    @Nullable
    V getOldValue();
}
