/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache;

import com.atlassian.annotations.PublicApi;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.util.concurrent.NotNull;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicApi
public abstract class CacheBuilder<K, V> {
    protected final String name;
    protected CacheLoader<K, V> loader = null;
    protected int maxSize = -1;
    protected long expireAfterMillis = -1L;
    protected boolean local = false;
    protected boolean flushable = true;

    protected CacheBuilder(@NotNull String name) {
        this.name = name;
    }

    public CacheBuilder<K, V> loader(CacheLoader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    public CacheBuilder<K, V> maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public CacheBuilder<K, V> expireAfterAccess(long expireAfter, TimeUnit timeUnit) {
        this.expireAfterMillis = timeUnit.toMillis(expireAfter);
        return this;
    }

    public CacheBuilder<K, V> flushable(boolean flushable) {
        this.flushable = flushable;
        return this;
    }

    public CacheBuilder<K, V> local(boolean local) {
        this.local = local;
        return this;
    }

    public abstract Cache<K, V> build();

    public String getName() {
        return this.name;
    }
}

