package com.atlassian.cache;

/**
 * Creates the actual cache implementation that the CacheManager will provide to clients.
 */
public interface CacheProvider
{
    /**
     * Creates the actual {@link com.atlassian.cache.Cache} implementation to return to clients.
     *
     * @param cacheName A unique name for the cache.
     * @param keyType The type for the key
     * @param valueType The type for the value
     * @return A {@link com.atlassian.cache.Cache} implementation
     */
    public <K, V> Cache<K, V> createCache(String cacheName, Class<K> keyType, Class<V> valueType);
}
