package com.atlassian.cache;

/**
 * Interface for creating caches.
 *
 * @see Cache
 * @see CacheManager
 */
public interface CacheFactory
{
    /**
     * Returns the cache with the given name, creates it if necessary.
     *
     * @param name the name of the cache
     * @return a Cache
     * @deprecated Since version 0.2. This is not typesafe.  Use {@link com.atlassian.cache.CacheFactory#getCache(String,
     *             Class, Class)} instead
     */
    <K, V> Cache<K, V> getCache(final String name);

    /**
     * Returns a cache with the given name, and the types specified.  Creates it if necessary.  If two caches of the
     * same name are queries, with different types, the call with incorrect type arguments will throw a
     * ClassCastException. For example with:<p/>
     * Cache<String,String> firstCache = cacheManager.getCache("myCache", String.class, String.class); <br/>
     * Cache<String,Long> secondCache = cacheManager.getCache("myCache", String.class, Long.class);
     * <p/>
     * the second call to getCache will result in a ClassCastException.
     *
     * @param name the name of the cache
     * @param keyType the type of keys in the cache.  Must extend Serializable
     * @param valueType the type of values in the cache. Must extend Serializable
     * @return a Cache
     */
    <K, V> Cache<K, V> getCache(final String name, Class<K> keyType, Class<V> valueType);
}
