package com.atlassian.cache;

import java.util.Collection;

public interface CacheManager extends CacheFactory
{
    /**
     * Gets the collection of caches managed. This collection is not a "live" collection. It is a copy.
     * @return a collection of {@link Cache}s.
     */
    Collection getCaches();

    /**
     * Flush the contents of all caches registered with the cache manager
     */
    void flushCaches();
}
