/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.util.ArgumentChecker;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public final class URIUtils {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final CharMatcher ALPHA = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).precomputed();
    private static final CharMatcher SCHEME_LEGAL = ALPHA.or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("+-.")).precomputed();
    private static final Function<String, String> LOWERCASE = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(@Nullable String input) {
            return input == null ? null : input.toLowerCase();
        }
    };
    private static final Function<URI, URI> URI_NORMALIZER = new Function<URI, URI>(){

        @Override
        @Nullable
        public URI apply(@Nullable URI input) {
            if (input == null) {
                return null;
            }
            URI uri = input.normalize();
            String scheme = uri.getScheme();
            String host = uri.getHost();
            if (scheme == null && host == null) {
                return uri;
            }
            String userinfo = uri.getUserInfo();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            try {
                return new URI((String)LOWERCASE.apply(scheme), userinfo, (String)LOWERCASE.apply(host), port, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("How did I get there??", e);
            }
        }
    };
    private static final Function<URI, URI> SCHEMAURI_NORMALIZER = new Function<URI, URI>(){

        @Override
        @Nullable
        public URI apply(@Nullable URI input) {
            URI uri = (URI)URI_NORMALIZER.apply(input);
            if (uri == null) {
                return null;
            }
            try {
                return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), Optional.fromNullable(uri.getFragment()).or(""));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("How did I get there??", e);
            }
        }
    };
    private static final ArgumentChecker<String> SCHEME_CHECKER = new ArgumentChecker<String>(){

        @Override
        public void check(String argument) {
            String errmsg = BUNDLE.printf("loadingCfg.illegalScheme", argument);
            if (argument.isEmpty()) {
                throw new IllegalArgumentException(errmsg);
            }
            if (!ALPHA.matches(argument.charAt(0))) {
                throw new IllegalArgumentException(errmsg);
            }
            if (!SCHEME_LEGAL.matchesAllOf(argument)) {
                throw new IllegalArgumentException(errmsg);
            }
        }
    };
    private static final ArgumentChecker<URI> PATHURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", argument);
            BUNDLE.checkArgumentPrintf(argument.getFragment() == null, "uriChecks.fragmentNotNull", argument);
            BUNDLE.checkArgumentPrintf(argument.getQuery() == null, "uriChecks.queryNotNull", argument);
            BUNDLE.checkArgumentPrintf(argument.getPath() != null, "uriChecks.noPath", argument);
            BUNDLE.checkArgumentPrintf(argument.getPath().endsWith("/"), "uriChecks.noEndingSlash", argument);
        }
    };
    private static final ArgumentChecker<URI> SCHEMAURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", argument);
            JsonRef ref = JsonRef.fromURI(argument);
            BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "uriChecks.notAbsoluteRef", argument);
            BUNDLE.checkArgumentPrintf(!argument.getPath().endsWith("/"), "uriChecks.endingSlash", argument);
        }
    };

    private URIUtils() {
    }

    public static Function<String, String> schemeNormalizer() {
        return LOWERCASE;
    }

    public static String normalizeScheme(@Nullable String scheme) {
        return LOWERCASE.apply(scheme);
    }

    public static Function<URI, URI> uriNormalizer() {
        return URI_NORMALIZER;
    }

    public static URI normalizeURI(@Nullable URI uri) {
        return URI_NORMALIZER.apply(uri);
    }

    public static Function<URI, URI> schemaURINormalizer() {
        return SCHEMAURI_NORMALIZER;
    }

    public static URI normalizeSchemaURI(@Nullable URI uri) {
        return SCHEMAURI_NORMALIZER.apply(uri);
    }

    public static ArgumentChecker<String> schemeChecker() {
        return SCHEME_CHECKER;
    }

    public static void checkScheme(String scheme) {
        SCHEME_CHECKER.check(scheme);
    }

    public static ArgumentChecker<URI> pathURIChecker() {
        return PATHURI_CHECKER;
    }

    public static void checkPathURI(URI uri) {
        PATHURI_CHECKER.check(uri);
    }

    public static ArgumentChecker<URI> schemaURIChecker() {
        return SCHEMAURI_CHECKER;
    }

    public static void checkSchemaURI(URI uri) {
        SCHEMAURI_CHECKER.check(uri);
    }
}

