/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.AbstractInstallConfigurator;
import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserType;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.browsers.MultiBrowserConfigurator;
import com.atlassian.browsers.NullConfigurator;
import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

final class BuiltInConfigurator {
    private final InstallConfigurator defaultInstallConfigurator = new MultiBrowserConfigurator.Builder().addConfigurator(BrowserType.CHROME, BuiltInChromeConfigurator.INSTANCE).addConfigurator(BrowserType.FIREFOX, NullConfigurator.INSTANCE).addConfigurator(BrowserType.IE, NullConfigurator.INSTANCE).build();
    private final InstallConfigurator clientConfigurator;

    protected BuiltInConfigurator(InstallConfigurator clientConfigurator) {
        this.clientConfigurator = (InstallConfigurator)Preconditions.checkNotNull((Object)clientConfigurator, (Object)"clientConfigurator");
    }

    public void setupBrowser(BrowserConfig browserConfig) {
        this.defaultInstallConfigurator.setupBrowser(browserConfig);
        this.clientConfigurator.setupBrowser(browserConfig);
        switch (browserConfig.getBrowserType()) {
            case FIREFOX: {
                this.clientConfigurator.setupFirefoxBrowser(browserConfig);
                break;
            }
            case CHROME: {
                this.clientConfigurator.setupChromeBrowser(browserConfig);
            }
        }
    }

    private static class BuiltInChromeConfigurator
    extends AbstractInstallConfigurator {
        static final BuiltInChromeConfigurator INSTANCE = new BuiltInChromeConfigurator();
        static final Iterable<String> CHROME_EXECUTABLES = ImmutableSet.of((Object)"Google Chrome Helper", (Object)"chrome", (Object)"chrome-sandbox", (Object)"google-chrome", (Object)"nacl_helper", (Object)"nacl_helper_bootstrap", (Object[])new String[]{"xdg-mime", "xdg-settings"});

        private BuiltInChromeConfigurator() {
        }

        @Override
        public void setupBrowser(@Nonnull BrowserConfig browserConfig) {
            try {
                if (!OsValidator.isWindows()) {
                    File chromedriver;
                    String profilePath;
                    if (browserConfig.getBrowserPath() != null) {
                        for (File executableFile : Utils.findFiles(browserConfig.getBrowserPath(), CHROME_EXECUTABLES)) {
                            Utils.make755(executableFile);
                        }
                    }
                    if ((profilePath = browserConfig.getProfilePath()) != null && (chromedriver = new File(profilePath, "chromedriver")).exists()) {
                        Utils.make755(chromedriver);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to apply permissions to one of the Chrome executables: %s", CHROME_EXECUTABLES), e);
            }
        }
    }
}

