/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.FieldOperation;
import com.atlassian.braid.mapper.MapperOperation;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;

final class OperationMappingResult {
    private final OperationDefinition operationDefinition;
    private final List<Selection> selections;
    private final List<MapperOperation> mappers;

    private OperationMappingResult(OperationDefinition operationDefinition) {
        this(operationDefinition, Collections.emptyList());
    }

    private OperationMappingResult(OperationDefinition operationDefinition, List<Selection> selections) {
        this(operationDefinition, new ArrayList<Selection>(selections), new ArrayList<MapperOperation>());
    }

    private OperationMappingResult(OperationDefinition operationDefinition, List<Selection> selections, List<MapperOperation> mappers) {
        this.operationDefinition = Objects.requireNonNull(operationDefinition);
        this.selections = Objects.requireNonNull(selections);
        this.mappers = Objects.requireNonNull(mappers);
    }

    OperationDefinition toOperationDefinition() {
        return new OperationDefinition(this.operationDefinition.getName(), this.operationDefinition.getOperation(), this.operationDefinition.getVariableDefinitions(), this.operationDefinition.getDirectives(), new SelectionSet(this.selections));
    }

    List<MapperOperation> getMapperOperations() {
        return Collections.unmodifiableList(this.mappers);
    }

    private void add(FieldOperation.FieldOperationResult result) {
        result.getField().ifPresent(this.selections::add);
        this.mappers.add(result.getMapper());
    }

    private static OperationMappingResult combine(OperationMappingResult omr1, OperationMappingResult omr2) {
        if (!Objects.equals(omr1.operationDefinition, omr2.operationDefinition)) {
            throw new IllegalArgumentException();
        }
        OperationMappingResult result = new OperationMappingResult(omr1.operationDefinition);
        result.selections.addAll(omr1.selections);
        result.selections.addAll(omr2.selections);
        result.mappers.addAll(omr1.mappers);
        result.mappers.addAll(omr2.mappers);
        return result;
    }

    static Collector<FieldOperation.FieldOperationResult, OperationMappingResult, OperationMappingResult> toOperationMappingResult(OperationDefinition operation, List<Selection> selections) {
        return Collector.of(() -> new OperationMappingResult(operation, selections), OperationMappingResult::add, OperationMappingResult::combine, new Collector.Characteristics[0]);
    }
}

