/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.OperationMappingResult;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.mapper.Mappers;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;

final class MappedOperations {
    private final List<OperationDefinition> definitions = new ArrayList<OperationDefinition>();
    private final List<MapperOperation> mappers = new ArrayList<MapperOperation>();

    private MappedOperations() {
    }

    private void add(OperationMappingResult result) {
        this.definitions.add(result.toOperationDefinition());
        this.mappers.addAll(result.getMapperOperations());
    }

    private static MappedOperations combine(MappedOperations mos1, MappedOperations mos2) {
        MappedOperations mappedOperations = new MappedOperations();
        mappedOperations.definitions.addAll(mos1.definitions);
        mappedOperations.definitions.addAll(mos2.definitions);
        mappedOperations.mappers.addAll(mos1.mappers);
        mappedOperations.mappers.addAll(mos2.mappers);
        return mappedOperations;
    }

    private DocumentMapper.MappedDocument getMappedDocument() {
        return new DocumentMapper.MappedDocument(this.getDocument(), this.getMapper());
    }

    private Document getDocument() {
        Document document = new Document();
        document.getDefinitions().addAll(this.definitions);
        return document;
    }

    private Mapper getMapper() {
        return Mappers.mapper(MapperOperations.composed(this.mappers));
    }

    static Collector<OperationMappingResult, MappedOperations, DocumentMapper.MappedDocument> toMappedDocument() {
        return Collector.of(MappedOperations::new, MappedOperations::add, MappedOperations::combine, MappedOperations::getMappedDocument, new Collector.Characteristics[0]);
    }
}

