/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.AbstractFieldOperation;
import com.atlassian.braid.document.DocumentMapperPredicates;
import com.atlassian.braid.document.FieldOperation;
import com.atlassian.braid.document.Fields;
import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.TypedDocumentMapper;
import com.atlassian.braid.mapper.MapperOperations;
import graphql.language.Field;
import graphql.language.SelectionSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

final class CopyFieldOperation
extends AbstractFieldOperation {
    private static final String ANY_NAME = "*";
    private final Function<Field, String> target;

    CopyFieldOperation() {
        this(ANY_NAME, ANY_NAME);
    }

    CopyFieldOperation(String key, String target) {
        this(CopyFieldOperation.copyPredicate(key), CopyFieldOperation.copyTarget(target));
    }

    private CopyFieldOperation(Predicate<Field> predicate, Function<Field, String> target) {
        super(predicate);
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public FieldOperation.FieldOperationResult apply(MappingContext mappingContext, Field field) {
        return CopyFieldOperation.getSelectionSet(field).map(__ -> TypedDocumentMapper.mapNode(mappingContext.to(field))).orElseGet(() -> this.mapLeaf(mappingContext, field));
    }

    private FieldOperation.FieldOperationResult mapLeaf(MappingContext mappingContext, Field field) {
        String targetKey = this.target.apply(field);
        return FieldOperation.result(Fields.cloneFieldWithNewName(field, targetKey), MapperOperations.copy(mappingContext.getSpringPath(targetKey), Fields.getFieldAliasOrName(field)));
    }

    private static Optional<SelectionSet> getSelectionSet(Field field) {
        return Optional.ofNullable(field.getSelectionSet());
    }

    private static Predicate<Field> copyPredicate(String key) {
        return Objects.equals(ANY_NAME, key) ? DocumentMapperPredicates.all() : DocumentMapperPredicates.fieldNamed(key);
    }

    private static Function<Field, String> copyTarget(String target) {
        return Objects.equals(ANY_NAME, target) ? Fields::getFieldAliasOrName : __ -> target;
    }
}

