/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BatchLoaderFactory;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.GraphQLQueryVisitor;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.GraphQLNodes;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.DocumentCloners;
import com.atlassian.braid.source.QueryFunction;
import com.atlassian.braid.source.RelativeGraphQLError;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

class QueryExecutor<C extends BraidContext>
implements BatchLoaderFactory<C> {
    private final QueryFunction<C> queryFunction;

    QueryExecutor(QueryFunction<C> queryFunction) {
        this.queryFunction = Objects.requireNonNull(queryFunction);
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return new QueryExecutorBatchLoader(schemaSource, link, this.queryFunction);
    }

    private static boolean isTargetIdNullAndCannotQueryLinkWithNull(Object targetId, Link link) {
        return targetId == null && !link.isNullable();
    }

    private static boolean isFieldQueryOnlySelectingVariable(Field field, Link link) {
        List selections = field.getSelectionSet().getSelections();
        return selections.stream().allMatch(s -> s instanceof Field) && selections.stream().map(BraidObjects::cast).allMatch(f -> f.getName().equals(link.getTargetVariableQueryField()));
    }

    private static VariableDefinition linkQueryVariableDefinition(Link link, String variableName, SchemaSource<?> schemaSource) {
        return new VariableDefinition(variableName, QueryExecutor.findArgumentType(schemaSource, link));
    }

    private static List<Argument> linkQueryArgumentAsList(Link link, String variableName) {
        return Collections.singletonList(new Argument(link.getArgumentName(), (Value)new VariableReference(variableName)));
    }

    private static Function<Field, String> createFieldAlias(int counter) {
        return field -> field.getName() + counter;
    }

    private static OperationDefinition newQueryOperationDefinition(GraphQLOutputType fieldType, OperationDefinition.Operation operationType) {
        return new OperationDefinition(QueryExecutor.newBulkOperationName(fieldType), operationType, new SelectionSet());
    }

    private static Optional<OperationDefinition.Operation> getOperationType(DataFetchingEnvironment env) {
        GraphQLType graphQLType = env.getParentType();
        GraphQLSchema graphQLSchema = env.getGraphQLSchema();
        if (Objects.equals(graphQLSchema.getQueryType(), graphQLType)) {
            return Optional.of(OperationDefinition.Operation.QUERY);
        }
        if (Objects.equals(graphQLSchema.getMutationType(), graphQLType)) {
            return Optional.of(OperationDefinition.Operation.MUTATION);
        }
        return Optional.empty();
    }

    private static String newBulkOperationName(GraphQLOutputType fieldType) {
        String type = fieldType instanceof GraphQLList ? ((GraphQLList)fieldType).getWrappedType().getName() : fieldType.getName();
        return "Bulk_" + type;
    }

    private static Field cloneFieldBeingFetchedWithAlias(DataFetchingEnvironment environment, Function<Field, String> alias) {
        Field field = QueryExecutor.cloneFieldBeingFetched(environment);
        field.setAlias(alias.apply(field));
        return field;
    }

    private static Field cloneFieldBeingFetched(DataFetchingEnvironment environment) {
        return DocumentCloners.clone(QueryExecutor.findCurrentFieldBeingFetched(environment));
    }

    private static ExecutionInput executeBatchQuery(Document doc, String operationName, Map<String, Object> variables) {
        return ExecutionInput.newExecutionInput().query(GraphQLNodes.printNode((Node)doc)).operationName(operationName).variables(variables).build();
    }

    private static List<DataFetcherResult<Object>> transformBatchResultIntoResultList(List<DataFetchingEnvironment> environments, Map<DataFetchingEnvironment, List<FieldKey>> clonedFields, DataFetcherResult<Map<FieldKey, Object>> result) {
        ArrayList<DataFetcherResult<Object>> queryResults = new ArrayList<DataFetcherResult<Object>>();
        Map data = (Map)result.getData();
        for (DataFetchingEnvironment environment : environments) {
            List fieldData;
            List<FieldKey> fields = clonedFields.get(environment);
            if (!fields.isEmpty()) {
                FieldKey field = fields.get(0);
                fieldData = (List)BraidObjects.cast(data.getOrDefault(field, null));
                if (environment.getFieldType() instanceof GraphQLList && !(fieldData instanceof List)) {
                    fieldData = fields.stream().map(f -> BraidObjects.cast(data.getOrDefault(f, null))).collect(Collectors.toList());
                } else if (fields.size() > 1) {
                    throw new IllegalStateException("Can't query for multiple fields if the target type isn't a list");
                }
            } else {
                fieldData = null;
            }
            queryResults.add((DataFetcherResult<Object>)new DataFetcherResult(fieldData, result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || fields.contains(new FieldKey(String.valueOf(e.getPath().get(0))))).map(RelativeGraphQLError::new).collect(Collectors.toList())));
        }
        return queryResults;
    }

    private static OperationDefinition findSingleOperationDefinition(Document queryDoc) {
        return (OperationDefinition)queryDoc.getDefinitions().stream().filter(d -> d instanceof OperationDefinition).map(OperationDefinition.class::cast).collect(BraidCollectors.singleton());
    }

    private static Type findArgumentType(SchemaSource<?> schemaSource, Link link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getTargetQueryField())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getArgumentName())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }

    private static Field findCurrentFieldBeingFetched(DataFetchingEnvironment environment) {
        return environment.getFields().stream().filter(QueryExecutor.isFieldMatchingFieldDefinition(environment.getFieldDefinition())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    private static Predicate<Field> isFieldMatchingFieldDefinition(GraphQLFieldDefinition fieldDefinition) {
        return field -> Objects.equals(fieldDefinition.getName(), field.getName());
    }

    static <C extends BraidContext> void trimFieldSelection(final SchemaSource<C> schemaSource, final DataFetchingEnvironment environment, final Field field) {
        new GraphQLQueryVisitor(){
            GraphQLOutputType parentType = null;
            GraphQLOutputType lastFieldType = null;

            @Override
            protected void visitField(Field node) {
                GraphQLOutputType type;
                if (node == field) {
                    type = environment.getFieldType();
                    this.parentType = (GraphQLObjectType)environment.getParentType();
                    Optional linkWithDifferentFromField = QueryExecutor.getLinkWithDifferentFromField(schemaSource.getLinks(), this.parentType.getName(), field.getName());
                    if (linkWithDifferentFromField.isPresent() && environment.getSource() == null) {
                        field.setSelectionSet(null);
                        field.setName(((Link)linkWithDifferentFromField.get()).getSourceFromField());
                    }
                } else {
                    QueryExecutor.getLink(schemaSource.getLinks(), this.parentType.getName(), node.getName()).ifPresent(l -> node.setSelectionSet(null));
                    type = QueryExecutor.isFieldMatchingFieldDefinition(Introspection.TypeNameMetaFieldDef).test(node) ? Introspection.TypeNameMetaFieldDef.getType() : (this.parentType instanceof GraphQLInterfaceType ? ((GraphQLInterfaceType)this.parentType).getFieldDefinition(node.getName()).getType() : ((GraphQLObjectType)this.parentType).getFieldDefinition(node.getName()).getType());
                }
                while (type instanceof GraphQLModifiedType) {
                    type = ((GraphQLModifiedType)type).getWrappedType();
                }
                this.lastFieldType = type;
                super.visitField(node);
            }

            @Override
            protected void visitSelectionSet(SelectionSet node) {
                if (node == null) {
                    return;
                }
                if (!node.getChildren().isEmpty()) {
                    GraphQLOutputType lastParentType = this.parentType;
                    this.parentType = this.lastFieldType;
                    for (Node child : node.getChildren()) {
                        Optional linkWithDifferentFromField;
                        if (child instanceof Field && (linkWithDifferentFromField = QueryExecutor.getLinkWithDifferentFromField(schemaSource.getLinks(), this.parentType.getName(), ((Field)child).getName())).isPresent()) {
                            this.removeSourceFieldIfDifferentThanFromField(node, (Link)linkWithDifferentFromField.get());
                            this.addFromFieldToQueryIfMissing(node, (Link)linkWithDifferentFromField.get());
                        }
                        this.visit(child);
                    }
                    this.parentType = lastParentType;
                }
            }

            private void addFromFieldToQueryIfMissing(SelectionSet node, Link link) {
                Optional<Selection> fromField = node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceFromField())).findFirst();
                if (!fromField.isPresent()) {
                    node.getSelections().add(new Field(link.getSourceFromField()));
                }
            }

            private void removeSourceFieldIfDifferentThanFromField(SelectionSet node, Link link) {
                node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceField())).findAny().ifPresent(s -> node.getSelections().remove(s));
            }
        }.visit((Node)field);
    }

    static Collection<Definition> processForFragments(final DataFetchingEnvironment environment, Field field) {
        final HashMap result = new HashMap();
        new GraphQLQueryVisitor(){

            @Override
            protected void visitFragmentSpread(FragmentSpread node) {
                FragmentDefinition fragmentDefinition = (FragmentDefinition)environment.getFragmentsByName().get(node.getName());
                result.put(node.getName(), fragmentDefinition.deepCopy());
                super.visitFragmentSpread(node);
            }
        }.visit((Node)field);
        return result.values();
    }

    private static Optional<Link> getLink(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static Optional<Link> getLinkWithDifferentFromField(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName) && !l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static class FieldKey {
        private final String value;

        private FieldKey(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return Objects.equals(this.value, fieldKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class FieldRequest {
        private final Field field;
        private final int counter;

        private FieldRequest(Field field, int counter) {
            this.field = field;
            this.counter = counter;
        }
    }

    private static class VariableNamespacingGraphQLQueryVisitor
    extends GraphQLQueryVisitor {
        private final int counter;
        private final OperationDefinition queryType;
        private final Map<String, Object> variables;
        private final DataFetchingEnvironment environment;
        private final OperationDefinition queryOp;

        VariableNamespacingGraphQLQueryVisitor(int counter, OperationDefinition operationDefinition, Map<String, Object> variables, DataFetchingEnvironment environment, OperationDefinition queryOp) {
            this.counter = counter;
            this.queryType = operationDefinition;
            this.variables = variables;
            this.environment = environment;
            this.queryOp = queryOp;
        }

        @Override
        protected void visitField(Field node) {
            node.setArguments(node.getArguments().stream().map(this::namespaceReferences).collect(Collectors.toList()));
            super.visitField(node);
        }

        private Argument namespaceReferences(Argument arg) {
            return new Argument(arg.getName(), this.namespaceReferences(arg.getValue()));
        }

        private Value namespaceReferences(Value value) {
            Object transformedValue = value instanceof VariableReference ? this.maybeNamespaceReference((VariableReference)value) : (value instanceof ObjectValue ? this.namespaceReferencesForObjectValue((ObjectValue)value) : value);
            return transformedValue;
        }

        private ObjectValue namespaceReferencesForObjectValue(ObjectValue value) {
            return new ObjectValue(value.getChildren().stream().map(ObjectField.class::cast).map(o -> new ObjectField(o.getName(), this.namespaceReferences(o.getValue()))).collect(Collectors.toList()));
        }

        private VariableReference maybeNamespaceReference(VariableReference value) {
            return this.isVariableAlreadyNamespaced(value) ? value : this.namespaceVariable(value);
        }

        private VariableReference namespaceVariable(VariableReference varRef) {
            String newName = varRef.getName() + this.counter;
            VariableReference value = new VariableReference(newName);
            Type type = VariableNamespacingGraphQLQueryVisitor.findVariableType(varRef, this.queryType);
            this.variables.put(newName, ((BraidContext)this.environment.getContext()).getVariables().get(varRef.getName()));
            this.queryOp.getVariableDefinitions().add(new VariableDefinition(newName, type));
            return value;
        }

        private boolean isVariableAlreadyNamespaced(VariableReference varRef) {
            return varRef.getName().endsWith(String.valueOf(this.counter));
        }

        private static Type findVariableType(VariableReference varRef, OperationDefinition queryType) {
            return queryType.getVariableDefinitions().stream().filter(d -> d.getName().equals(varRef.getName())).map(VariableDefinition::getType).findFirst().orElseThrow(IllegalArgumentException::new);
        }
    }

    private static class QueryExecutorBatchLoader<C extends BraidContext>
    implements BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> {
        private final SchemaSource<C> schemaSource;
        private final Link link;
        private final QueryFunction<?> queryFunction;

        private QueryExecutorBatchLoader(SchemaSource<C> schemaSource, Link link, QueryFunction<?> queryFunction) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
            this.link = link;
            this.queryFunction = Objects.requireNonNull(queryFunction);
        }

        public CompletionStage<List<DataFetcherResult<Object>>> load(List<DataFetchingEnvironment> environments) {
            DataFetchingEnvironment firstEnv = (DataFetchingEnvironment)environments.stream().findFirst().orElseThrow(IllegalStateException::new);
            GraphQLOutputType fieldType = firstEnv.getFieldDefinition().getType();
            Document doc = new Document();
            OperationDefinition.Operation operationType = QueryExecutor.getOperationType(firstEnv).orElse(OperationDefinition.Operation.QUERY);
            OperationDefinition queryOp = QueryExecutor.newQueryOperationDefinition(fieldType, operationType);
            doc.getDefinitions().add(queryOp);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            HashMap clonedFields = new HashMap();
            AtomicInteger counter = new AtomicInteger(99);
            HashMap<FieldKey, 1> shortCircuitedData = new HashMap<FieldKey, 1>();
            for (DataFetchingEnvironment environment : environments) {
                ArrayList<FieldRequest> fields = new ArrayList<FieldRequest>();
                ArrayList<Integer> usedCounterIds = new ArrayList<Integer>();
                Document queryDoc = new Parser().parseDocument(((BraidContext)environment.getContext()).getQuery());
                OperationDefinition operationDefinition = QueryExecutor.findSingleOperationDefinition(queryDoc);
                if (this.link != null) {
                    List targetIds = BatchLoaderUtils.getTargetIdsFromEnvironment(this.link, environment);
                    boolean fieldQueryOnlySelectingVariable = QueryExecutor.isFieldQueryOnlySelectingVariable(QueryExecutor.cloneFieldBeingFetched(environment), this.link);
                    for (final Object targetId : targetIds) {
                        FieldRequest field = this.cloneField(this.schemaSource, counter, usedCounterIds, environment);
                        if (QueryExecutor.isTargetIdNullAndCannotQueryLinkWithNull(targetId, this.link)) {
                            shortCircuitedData.put(new FieldKey(field.field.getAlias()), null);
                        } else if (fieldQueryOnlySelectingVariable) {
                            shortCircuitedData.put(new FieldKey(field.field.getAlias()), new HashMap<String, Object>(){
                                {
                                    this.put(link.getTargetVariableQueryField(), targetId);
                                }
                            });
                        } else {
                            this.addQueryVariable(queryOp, variables, counter, targetId, field);
                            this.addFieldToQuery(doc, queryOp, variables, environment, operationDefinition, field);
                        }
                        fields.add(field);
                    }
                } else {
                    FieldRequest field = this.cloneField(this.schemaSource, counter, usedCounterIds, environment);
                    fields.add(field);
                    this.addFieldToQuery(doc, queryOp, variables, environment, operationDefinition, field);
                }
                clonedFields.put(environment, fields.stream().map(f -> ((FieldRequest)f).field.getAlias()).map(x$0 -> new FieldKey((String)x$0)).collect(Collectors.toList()));
            }
            CompletableFuture<DataFetcherResult<Map<String, Object>>> queryResult = this.executeQuery(environments, doc, queryOp, variables);
            return ((CompletableFuture)queryResult.thenApply(result -> {
                HashMap<FieldKey, Object> data = new HashMap<FieldKey, Object>();
                Map<FieldKey, Object> dataByKey = ((Map)result.getData()).entrySet().stream().collect(Collectors.toMap(e -> new FieldKey((String)e.getKey()), Map.Entry::getValue));
                data.putAll(dataByKey);
                data.putAll(shortCircuitedData);
                return new DataFetcherResult(data, result.getErrors());
            })).thenApply(result -> QueryExecutor.transformBatchResultIntoResultList(environments, clonedFields, (DataFetcherResult<Map<FieldKey, Object>>)result));
        }

        private void addFieldToQuery(Document doc, OperationDefinition queryOp, Map<String, Object> variables, DataFetchingEnvironment environment, OperationDefinition operationDefinition, FieldRequest field) {
            VariableNamespacingGraphQLQueryVisitor variableNameSpacer = new VariableNamespacingGraphQLQueryVisitor(field.counter, operationDefinition, variables, environment, queryOp);
            QueryExecutor.processForFragments(environment, field.field).forEach(d -> {
                variableNameSpacer.visit((Node)d);
                doc.getDefinitions().add(d);
            });
            variableNameSpacer.visit((Node)field.field);
            queryOp.getSelectionSet().getSelections().add(field.field);
        }

        private CompletableFuture<DataFetcherResult<Map<String, Object>>> executeQuery(List<DataFetchingEnvironment> environments, Document doc, OperationDefinition queryOp, Map<String, Object> variables) {
            CompletableFuture<DataFetcherResult<Map<String, Object>>> queryResult;
            if (queryOp.getSelectionSet().getSelections().isEmpty()) {
                queryResult = CompletableFuture.completedFuture(new DataFetcherResult(Collections.emptyMap(), Collections.emptyList()));
            } else {
                ExecutionInput input = QueryExecutor.executeBatchQuery(doc, queryOp.getName(), variables);
                queryResult = this.queryFunction.query(input, (BraidContext)environments.get(0).getContext());
            }
            return queryResult;
        }

        private void addQueryVariable(OperationDefinition queryOp, Map<String, Object> variables, AtomicInteger counter, Object targetId, FieldRequest field) {
            String variableName = this.link.getArgumentName() + counter;
            field.field.setName(this.link.getTargetQueryField());
            field.field.setArguments(QueryExecutor.linkQueryArgumentAsList(this.link, variableName));
            queryOp.getVariableDefinitions().add(QueryExecutor.linkQueryVariableDefinition(this.link, variableName, this.schemaSource));
            variables.put(variableName, targetId);
        }

        private FieldRequest cloneField(SchemaSource<C> schemaSource, AtomicInteger counter, List<Integer> usedCounterIds, DataFetchingEnvironment environment) {
            Field field = QueryExecutor.cloneFieldBeingFetchedWithAlias(environment, QueryExecutor.createFieldAlias(counter.incrementAndGet()));
            usedCounterIds.add(counter.get());
            QueryExecutor.trimFieldSelection(schemaSource, environment, field);
            return new FieldRequest(field, counter.get());
        }
    }
}

