/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperImpl;
import com.atlassian.braid.mapper.MapperInputOutput;
import com.atlassian.braid.mapper.MapperMaps;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.mapper.YamlMappers;
import java.io.Reader;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Mappers {
    private Mappers() {
    }

    public static Mapper mapper() {
        return new MapperImpl();
    }

    public static Mapper fromYaml(Supplier<Reader> yaml) {
        return Mappers.fromYamlMap(YamlMappers.load(yaml));
    }

    public static Mapper fromYamlMap(Map<String, Object> yamlAsMap) {
        return new MapperImpl(MapperOperations.composed(YamlMappers.toMapperOperations(yamlAsMap)));
    }

    public static Predicate<MapperInputOutput> inputContains(String key) {
        return inout -> MapperMaps.get(inout.getInput(), key).isPresent();
    }
}

