/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.ExpressionEvaluator;
import java.util.Map;
import java.util.Optional;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpringExpressionEvaluator
implements ExpressionEvaluator {
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    @Override
    public <T> Optional<T> getValue(Map<String, Object> source, String sourcePath) {
        if (!sourcePath.contains("[")) {
            sourcePath = "['" + sourcePath + "']";
        }
        return Optional.ofNullable(this.maybeGetValue(source, sourcePath)).map(SpringExpressionEvaluator::cast);
    }

    private Object maybeGetValue(Object source, String sourcePath) {
        return PARSER.parseExpression(sourcePath).getValue(source);
    }

    private static <T> T cast(Object value) {
        return (T)value;
    }
}

