/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.DefaultMapper;
import com.atlassian.braid.mapper.ExpressionEvaluator;
import com.atlassian.braid.mapper.SimpleExpressionEvaluator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Mapper {
    public Mapper copy(String var1);

    public <T, R> Mapper copy(String var1, Function<T, R> var2);

    public <T> Mapper copy(String var1, Supplier<T> var2);

    public <T, R> Mapper copy(String var1, Function<T, R> var2, Supplier<R> var3);

    public Mapper copy(String var1, String var2);

    public <T> Mapper copy(String var1, String var2, Supplier<T> var3);

    public <T, R> Mapper copy(String var1, String var2, Function<T, R> var3);

    public <T, R> Mapper copy(String var1, String var2, Function<T, R> var3, Supplier<R> var4);

    public Mapper copyMap(String var1);

    public Mapper copyMap(String var1, String var2);

    public Mapper map(String var1);

    public Mapper singletonList(String var1);

    public Mapper put(String var1, Object var2);

    public Mapper copyList(String var1, String var2);

    public Mapper copyList(String var1);

    public Mapper done();

    public Map<String, Object> build();

    public static Mapper newMapper(Map<String, Object> data) {
        ExpressionEvaluator evaluator;
        Logger log = LoggerFactory.getLogger(Mapper.class);
        try {
            Class<?> cls = Mapper.class.getClassLoader().loadClass("com.atlassian.braid.mapper.SpringExpressionEvaluator");
            evaluator = (ExpressionEvaluator)cls.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.debug("Spring not found, using simple property expressions");
            evaluator = new SimpleExpressionEvaluator();
        }
        return new DefaultMapper(evaluator, data);
    }
}

